/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.panes;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.ftb.data.LauncherStyle;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.EditModPackDialog;
import net.ftb.gui.dialogs.ModPackFilterDialog;
import net.ftb.gui.dialogs.PrivatePackDialog;
import net.ftb.gui.panes.AbstractModPackPane;
import net.ftb.gui.panes.ILauncherPane;
import net.ftb.locale.I18N;
import net.ftb.util.DownloadUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.TrackerUtils;

public class FTBPacksPane
extends AbstractModPackPane
implements ILauncherPane {
    private static FTBPacksPane instance;
    private JScrollPane packsScroll;

    public FTBPacksPane() {
        instance = this;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(null);
        this.packPanels = Lists.newArrayList();
        this.packs = new JPanel();
        this.packs.setLayout(null);
        this.packs.setOpaque(false);
        JPanel p = new JPanel();
        p.setBounds(0, 0, 420, 55);
        p.setLayout(null);
        this.filter = new JButton(I18N.getLocaleString("FILTER_SETTINGS"));
        this.filter.setBounds(5, 5, 105, 25);
        this.filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FTBPacksPane.this.loaded) {
                    ModPackFilterDialog filterDia = new ModPackFilterDialog(instance);
                    filterDia.setVisible(true);
                }
            }
        });
        this.add(this.filter);
        String filterTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterTextColor);
        String filterInnerTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterInnerTextColor);
        String typeLblText = "<html><body>";
        typeLblText = typeLblText + "<strong><font color=rgb\"(" + filterTextColor + ")\">Filter: </strong></font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + this.origin + "</font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterTextColor + ")\"> / </font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + this.mcVersion + "</font>";
        typeLblText = typeLblText + "</body></html>";
        this.typeLbl = new JLabel(typeLblText);
        this.typeLbl.setBounds(115, 5, 175, 25);
        this.typeLbl.setHorizontalAlignment(0);
        this.add(this.typeLbl);
        this.editModPack = new JButton(I18N.getLocaleString("MODS_EDIT_PACK"));
        this.editModPack.setBounds(300, 5, 110, 25);
        this.editModPack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FTBPacksPane.this.packPanels.size() > 0 && FTBPacksPane.this.getSelectedFTBModIndex() >= 0) {
                    EditModPackDialog empd = new EditModPackDialog(LaunchFrame.getInstance(), ModPack.getSelectedPack(true));
                    empd.setVisible(true);
                }
            }
        });
        this.add(this.editModPack);
        JTextArea filler = new JTextArea(I18N.getLocaleString("MODS_WAIT_WHILE_LOADING"));
        filler.setBorder(null);
        filler.setEditable(false);
        filler.setForeground(LauncherStyle.getCurrentStyle().tabPaneForeground);
        filler.setBounds(58, 6, 378, 42);
        filler.setBackground(LauncherStyle.getCurrentStyle().tabPaneBackground);
        p.add(filler);
        this.packs.add(p);
        this.packsScroll = new JScrollPane();
        this.packsScroll.setBounds(-3, 30, 420, 283);
        this.packsScroll.setHorizontalScrollBarPolicy(31);
        this.packsScroll.setVerticalScrollBarPolicy(22);
        this.packsScroll.setWheelScrollingEnabled(true);
        this.packsScroll.setOpaque(false);
        this.packsScroll.setViewportView(this.packs);
        this.packsScroll.getVerticalScrollBar().setUnitIncrement(19);
        this.add(this.packsScroll);
        this.packInfo = new JEditorPane();
        this.packInfo.setEditable(false);
        this.packInfo.setContentType("text/html");
        this.packInfo.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    OSUtils.browse(event.getURL().toString());
                }
            }
        });
        this.packInfo.setBackground(UIManager.getColor("control").darker().darker());
        this.add(this.packInfo);
        this.infoScroll = new JScrollPane();
        this.infoScroll.setBounds(410, 25, 430, 290);
        this.infoScroll.setHorizontalScrollBarPolicy(31);
        this.infoScroll.setVerticalScrollBarPolicy(20);
        this.infoScroll.setWheelScrollingEnabled(true);
        this.infoScroll.setViewportView(this.packInfo);
        this.infoScroll.setOpaque(false);
        this.add(this.infoScroll);
        this.server = new JButton(I18N.getLocaleString("DOWNLOAD_SERVER"));
        this.server.setBounds(420, 5, 130, 25);
        this.server.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ModPack pack = ModPack.getSelectedPack(true);
                if (LaunchFrame.currentPane == LaunchFrame.Panes.MODPACK && !pack.getServerUrl().isEmpty() && FTBPacksPane.this.packPanels.size() > 0 && FTBPacksPane.this.getSelectedFTBModIndex() >= 0 && !pack.getServerUrl().equals("") && pack.getServerUrl() != null) {
                    String version;
                    String string = version = Settings.getSettings().getPackVer().equalsIgnoreCase("recommended version") || Settings.getSettings().getPackVer().equalsIgnoreCase("newest version") ? pack.getVersion().replace(".", "_") : Settings.getSettings().getPackVer().replace(".", "_");
                    if (pack.isPrivatePack()) {
                        OSUtils.browse(DownloadUtils.getCreeperhostLink("privatepacks%5E" + pack.getDir() + "%5E" + version + "%5E" + pack.getServerUrl()));
                    } else {
                        OSUtils.browse(DownloadUtils.getCreeperhostLink("modpacks%5E" + pack.getDir() + "%5E" + version + "%5E" + pack.getServerUrl()));
                    }
                    TrackerUtils.sendPageView(pack.getName() + " Server Download", pack.getName());
                }
            }
        });
        this.add(this.server);
        this.version = new JComboBox<String>(new String[0]);
        this.version.setBounds(560, 5, 130, 25);
        this.version.addActionListener(this.al);
        this.version.setToolTipText(I18N.getLocaleString("MODPACK_VERSIONS"));
        this.add(this.version);
        this.privatePack = new JButton(I18N.getLocaleString("PACK_CODES"));
        this.privatePack.setBounds(700, 5, 120, 25);
        this.privatePack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivatePackDialog ap = new PrivatePackDialog();
                ap.setVisible(true);
            }
        });
        this.add(this.privatePack);
    }

    @Override
    public void onVisible() {
        FTBPacksPane.getInstance().getPacksScroll().getViewport().setViewPosition(new Point(0, 0));
    }

    public int getSelectedFTBModIndex() {
        return this.modPacksAdded ? this.getIndex() : -1;
    }

    @Override
    boolean filterForTab(ModPack pack) {
        return !pack.isThirdPartyTab();
    }

    @Override
    String getLastPack() {
        return Settings.getSettings().getLastFTBPack();
    }

    @Override
    String getPaneShortName() {
        return "FTB";
    }

    @Override
    boolean isFTB() {
        return true;
    }

    public static FTBPacksPane getInstance() {
        return instance;
    }

    public JScrollPane getPacksScroll() {
        return this.packsScroll;
    }
}

